/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.utils.TranslationUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MagnetItem
extends Item {
    public MagnetItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            CompoundTag compoundTag = stack.m_41784_();
            if (compoundTag.m_128471_("active")) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.active").m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.ITALIC})));
            }
            if (!compoundTag.m_128471_("active")) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.inactive").m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.ITALIC})));
            }
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.spelunkery.item_magnet_1", (Object[])new Object[]{this.getMagnetRange()}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.item_magnet_2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)TranslationUtils.CROUCH.component());
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        MagnetItem.toggleMagnet(player, stack, level);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static void toggleMagnet(Player player, ItemStack stack, Level level) {
        if (!player.f_19853_.f_46443_ && stack.m_41720_() instanceof MagnetItem) {
            boolean active = stack.m_41784_().m_128441_("active") && stack.m_41784_().m_128471_("active");
            SoundEvent beaconSound = active ? SoundEvents.f_11738_ : SoundEvents.f_11736_;
            level.m_5594_(null, player.m_20183_(), beaconSound, SoundSource.BLOCKS, 1.0f, 2.0f);
            stack.m_41784_().m_128379_("active", !active);
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128441_("active") && stack.m_41784_().m_128471_("active");
    }

    public int getMagnetRange() {
        return CommonConfigs.MAGNET_RANGE.get();
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity.m_5833_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("active") && tag.m_128471_("active")) {
            int r = this.getMagnetRange();
            AABB area = new AABB(entity.m_20182_().m_82520_((double)(-r), (double)(-r), (double)(-r)), entity.m_20182_().m_82520_((double)r, (double)r, (double)r));
            List items = level.m_142425_((EntityTypeTest)EntityType.f_20461_, area, item -> !(!item.m_6084_() || level.f_46443_ && item.f_19797_ <= 1 || item.m_32057_() != null && item.m_32057_().equals(entity.m_20148_()) && item.m_32063_() || item.m_32055_().m_41619_()));
            items.forEach(item -> item.m_20256_(item.m_20184_().m_82549_(new Vec3(entity.m_20182_().f_82479_ - item.m_20185_(), entity.m_20182_().f_82480_ - item.m_20186_(), entity.m_20182_().f_82481_ - item.m_20189_()).m_82541_().m_82490_((1.4 - Math.sqrt(new Vec3(entity.m_20182_().f_82479_ - item.m_20185_(), entity.m_20182_().f_82480_ - item.m_20186_(), entity.m_20182_().f_82481_ - item.m_20189_()).m_82556_()) / 8.0) * (1.4 - Math.sqrt(new Vec3(entity.m_20182_().f_82479_ - item.m_20185_(), entity.m_20182_().f_82480_ - item.m_20186_(), entity.m_20182_().f_82481_ - item.m_20189_()).m_82556_()) / 8.0) * 0.1))));
        }
    }
}

